#ifndef __TOKENREADER__
#define __TOKENREADER__

// token types
enum Token
{
	TOKEN_ERROR,
	TOKEN_NONE,
	TOKEN_EOF,
	TOKEN_OPERATOR,
	TOKEN_NUMBER,
	TOKEN_STRING,
	TOKEN_IDENTIFIER,
	TOKEN_COMMENT,
};

// tokenreader.
class TokenReader
{
	public:
		TokenReader( );
		TokenReader( char* data );
		~TokenReader( );

		// read token.
		virtual Token ReadToken( char* buffer, int maxsize );

	protected:
		// oh blarg?!? should they be able to override these?
		virtual void SkipWhiteSpace( );
		virtual void GetString( char* buffer, int maxsize );

		// token stuffing.
		void StuffToken( Token token, char* data ) { stuffed_data = data; stuffed_token = token; }

		// general control stuff.
		inline void consume( int count )
		{
			while( count > 0 )
			{
				data_pointer++;
				count--;

			}

		}
		inline char get( ) { return *data_pointer++; }
		inline void putback( ) { data_pointer--; }
		inline char peek( ) { char ch = get(); putback(); return ch; }
		inline void peekstring( char* buffer, int len );
		inline void ignore( char ignore )
		{
			// read
			char ch = get();
			while( ch != ignore || ch == '\0' )
			{
				ch = get();

			}

		}


	private:
		// our data pointer.
		char* data_pointer;

		// token stuffing.
		bool token_stuffed;
		char* stuffed_data;
		Token stuffed_token;
		

};

#endif
